proc tabulate data = ghpb22;

class ent3 INS3 filingsize / PRELOADFMT;
title 'Table B4. Premiums Paid by Group Health Plans';
title2 'by type of insurance, type of plan, and type of insurance contracts, 2022';
title3 '(millions)';
title4 'All Plans';
var TOT_PREM HEALTH_ONLY_PREM STOPLOSS_ONLY_PREM OTHER_ONLY_PREM HEALTH_STOPLOSS_PREM HEALTH_OTHER_PREM STOPLOSS_OTHER_PREM HEALTH_STOPLOSS_OTHER_PREM;
WEIGHT DUP_WGT;
table (TOT_PREM ='Total'
HEALTH_ONLY_PREM ='Health Only'
STOPLOSS_ONLY_PREM ='Stop-Loss Only'
OTHER_ONLY_PREM ='Other'
HEALTH_STOPLOSS_PREM ='Health and Stop-Loss'
HEALTH_OTHER_PREM ='Health and Other'
STOPLOSS_OTHER_PREM ='Stop-Loss and Other'
HEALTH_STOPLOSS_OTHER_PREM='Health, Stop-Loss, and Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/MISSTEXT='-' box='Type of Insurance Contracts';
run;

proc tabulate data = ghpb22;
where filingsize='1';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table B4. Premiums Paid by Group Health Plans';
title2 'by type of insurance, type of plan, and type of insurance contracts, 2022';
title3 '(millions)';
title4 'Plans with 100 or More Participants and Trusts';
var TOT_PREM HEALTH_ONLY_PREM STOPLOSS_ONLY_PREM OTHER_ONLY_PREM HEALTH_STOPLOSS_PREM HEALTH_OTHER_PREM STOPLOSS_OTHER_PREM HEALTH_STOPLOSS_OTHER_PREM;
WEIGHT DUP_WGT;
table (TOT_PREM ='Total'
HEALTH_ONLY_PREM ='Health Only'
STOPLOSS_ONLY_PREM ='Stop-Loss Only'
OTHER_ONLY_PREM ='Other'
HEALTH_STOPLOSS_PREM ='Health and Stop-Loss'
HEALTH_OTHER_PREM ='Health and Other'
STOPLOSS_OTHER_PREM ='Stop-Loss and Other'
HEALTH_STOPLOSS_OTHER_PREM='Health, Stop-Loss, and Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/MISSTEXT='-' box='Type of Insurance Contracts';
run;

proc tabulate data = ghpb22;
where filingsize='2';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table B4. Premiums Paid by Group Health Plans';
title2 'by type of insurance, type of plan, and type of insurance contracts, 2022';
title3 '(millions)';
title4 'Plans with 100 or More Participants and No Trusts';
var TOT_PREM HEALTH_ONLY_PREM STOPLOSS_ONLY_PREM OTHER_ONLY_PREM HEALTH_STOPLOSS_PREM HEALTH_OTHER_PREM STOPLOSS_OTHER_PREM HEALTH_STOPLOSS_OTHER_PREM;
WEIGHT DUP_WGT;
table (TOT_PREM ='Total'
HEALTH_ONLY_PREM ='Health Only'
STOPLOSS_ONLY_PREM ='Stop-Loss Only'
OTHER_ONLY_PREM ='Other'
HEALTH_STOPLOSS_PREM ='Health and Stop-Loss'
HEALTH_OTHER_PREM ='Health and Other'
STOPLOSS_OTHER_PREM ='Stop-Loss and Other'
HEALTH_STOPLOSS_OTHER_PREM='Health, Stop-Loss, and Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/MISSTEXT='-' box='Type of Insurance Contracts';
run;

proc tabulate data = ghpb22;
where filingsize='3';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table B4. Premiums Paid by Group Health Plans';
title2 'by type of insurance, type of plan, and type of insurance contracts, 2022';
title3 '(numbers in millions)';
title4 'Plans with Fewer Than 100 Participants and Trusts';
var TOT_PREM HEALTH_ONLY_PREM STOPLOSS_ONLY_PREM OTHER_ONLY_PREM HEALTH_STOPLOSS_PREM HEALTH_OTHER_PREM STOPLOSS_OTHER_PREM HEALTH_STOPLOSS_OTHER_PREM;
WEIGHT DUP_WGT;
table (TOT_PREM ='Total'
HEALTH_ONLY_PREM ='Health Only'
STOPLOSS_ONLY_PREM ='Stop-Loss Only'
OTHER_ONLY_PREM ='Other'
HEALTH_STOPLOSS_PREM ='Health and Stop-Loss'
HEALTH_OTHER_PREM ='Health and Other'
STOPLOSS_OTHER_PREM ='Stop-Loss and Other'
HEALTH_STOPLOSS_OTHER_PREM='Health, Stop-Loss, and Other')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/MISSTEXT='-' box='Type of Insurance Contracts';
run;
